<?php
Yii::import("webroot.themes.press.ThemeFunctions"); 
$epaper_config = ModuleLoader::getConfig("epaper");
$epaper_mediadir = Yii::app()->getBaseUrl(true) . Yii::app()->params['uploadDir'] . $epaper_config["mediaDir"];

 
  if (count($subcategory_models) > 0) { ?>

        <section class="subcategory-block">
            <h2>
                <span class="glyphicon glyphicon-plus"></span> <span class="visible-status"><?php echo Yii::t("theme_press","Show"); ?></span> 
                <?php if ($id == 0) { ?>
                    <?php echo Yii::t("theme_press","All Categories"); ?>
                <?php } else { ?>
                    <?php echo Yii::t("theme_press","Subcategories"); ?>
                <?php } ?>
            </h2>

            <div class="content">
                <?php
                $n = 1;
                foreach ($subcategory_models as $model) {
                    $imageurl = $epaper_mediadir . $model->cat_image;
                    if (trim($model->cat_image) == "") {
                        $thumb = ImageHelpers::i()->getDefaultImage(100, 100, true);
                    } else {
                        $thumb = ImageHelpers::i()->getThumbImage($imageurl, 100, 100, true);
                    }
                    if ($n == 1) {
                        echo "<div class='row'>";
                    }
                    ?>

                    <div class="col-lg-3 col-md-6 col-sm-6 col-xs-12">
                        <div class="clearfix float">
                            <div class="image">
                                <a class="thumbnail" href="<?php echo $this->createUrl("//epaper/default/index", array("id" => $model->cat_id, "alias" => $model->cat_alias)); ?>">
                                    <img src="<?php echo $thumb; ?>" />
                                </a>
                            </div>
                            <div class="description">
                                <h3><?php echo CHtml::link(CHtml::encode($model->cat_title), $this->createUrl("//epaper/default/index", array("id" => $model->cat_id, "alias" => $model->cat_alias))); ?></h3>
                                <p><?php echo CHtml::encode(Helpers::i()->wordLimiter($model->cat_desc, 17)); ?></p>
                            </div>
                        </div>
                    </div>   

                    <?php
                    if ($n == 4) {
                        echo "</div>";
                        $n = 1;
                    } else {
                        $n++;
                    }
                }
                if ($n != 1) {
                    echo "</div>";
                }
                ?>            
            </div>
 
        </section>
        <script>
            var content_visible = false;
            $(".subcategory-block .content").hide();
            $(".subcategory-block h2").on("click", function(e) {
                if (content_visible == false) {
                    $(".subcategory-block .content").show("slow");
                    $(".subcategory-block .glyphicon").removeClass("glyphicon-plus").addClass("glyphicon-minus");
                    $(".visible-status").text("<?php echo Yii::t("theme_press","Hide") ?>");
                    content_visible = true;
                } else {
                    $(".subcategory-block .content").hide("slow");
                    $(".subcategory-block .glyphicon").addClass("glyphicon-plus").removeClass("glyphicon-minus");
                    $(".visible-status").text("<?php echo Yii::t("theme_press","Show") ?>");
                    content_visible = false;
                }
            });
        </script>
    <?php } ?>
 